class Complex
{
      private:
              double real;
              double img;
      public:
      Complex(double r):real(r),img(0)
             { }
     Complex(double r, double i):real(r),img(i)
             { }
      double getReal() const
      {   return real;  }
      
      double getimg() const
      {   return img;  }
      void setReal(double r)
      { real=r;}
      void setImg(double i)
      { img=i;}
      Complex add(Complex x)
      {
           double r = real + x.real;
           double i = img + x.img;
           return Complex(r,i);
       }
       bool operator ==(Complex x)
       {
            return (x.real==real && x.real==real);
            }
       
    friend Complex external_add(Complex,Complex);   
    friend void show(Complex );
    friend Complex operator +(Complex,Complex);
};

Complex operator + (Complex x, Complex y)
{
    double r=x.real+y.real;
    double i=x.img+y.img;
    return Complex(r,i);    
        }

Complex external_add(Complex x, Complex y=Complex(0,0))  // here we use default argument value for y
{
  /* is similar to the add method . but this time it is external
  *that it is not part of an object , so we pass two objects to add this time
  */     
  double r=x.real+y.real;
  double i=x.img+y.img;
  return Complex(r,i);
        }
